function [Ke]=bar1e(ex,ep)
// Ke=bar2e(ex,ey,ep)
//----------------------------------------------------------------------
// PURPOSE
//  Compute the element stiffness matrix for two dimensional bar element.
//
// INPUT:  ex = [x1 x2];      element node coordinates
//
//         ep = [E A]         E: Young's modulus
//                            A: Cross section area
//
// OUTPUT: Ke : stiffness matrix, dim(Ke)= 2 x 2
//----------------------------------------------------------------------
// LAST MODIFIED: T. Jankowiak (2010)
//-------------------------------------------------------------
E=ep(1);  A=ep(2); 
b=[ex(2)-ex(1)];
L=sqrt(b*b);
Ke=E*A/L*[ 1 -1;-1  1];
endfunction

