function [magnfac]=eldia2(ex,ey,es,eci,magnfac,magnitude)
[nargout,nargin] = argn(0);

// Display warning for floating point exception
ieee(1)

//[magnfac]=eldia2(ex,ey,es,eci)
//eldia2(ex,ey,es,eci,magnfac,magnitude)
//eldia2(ex,ey,es,eci,magnfac)
//
//-------------------------------------------------------------
// PURPOSE: 
//  Draw the section force diagrams of a two dimensional beam element.
//  	
// INPUT:
//	ex = [ x1 x2 ]
//	ey = [ y1 y2 ]	element node coordinates.
//
//	es = [  X1;
//		X2;
//		... ] 	vector containing the section force
//			in Nbr evaluation points along the beam.
//	
//	eci = [	x1;
//		x2;
//		... ]	local x-coordinates of the evaluation points (Nbr).
//
//	magnfac = [scalar]	magnification factor.
//	
//	Rem. if magnfac is omitted in the input list it is calculated
//            as an output parameter.
//
//	magnitude = [Ref x y]	Draw a scaled bar, with a lenth equivalent   
//				to Ref, starting at coordinates (x,y).
//				If no coordinates are given the starting
//				point will be (0,-0.5).
//
//	Rem. if magnitude is omitted in the input no scaled bar is provided.
//
//-------------------------------------------------------------

// LAST MODIFIED: A Olsson 	1999-03-01
// Copyright (c)  Division of Structural Mechanics and
//                Department of Solid Mechanics.
//                Lund Institute of Technology
//-------------------------------------------------------------

if ~((nargin==4)|(nargin==5)|(nargin==6))
    disp('??? Wrong number of input arguments!')
    return
 end
a=size(ex); b=size(ey);
 
 if ~((a-b)==[0 0])
    disp('??? Check size of coordinate input arguments!')
   return
 end
c=size(es);
a=size(eci); 
 if ~(c(1)==a(1)|(c(2)==1))
    disp('??? Check size of (es) or (eci) input arguments!')
   return
 end 
b=[ex(2)-ex(1);ey(2)-ey(1)];
Length=sqrt(b'*b);
n=b/Length;
if nargin==4
	// Determining magnfac.
	magnfac=max(abs(es))/(0.2*Length);
else
   disp("wykres")
end
es=es/magnfac;
if nargin>5
	// Creating a scaled bar.
	N=magnitude(1);
	L=N/magnfac;
	mag=size(magnitude);
	if mag(2)==1
		x=0;
		y=-0.5;
	else
		x=magnitude(2);
		y=magnitude(3);
	end;
	plot2d([x (x+L)],[y y],5,rect=[-2 -0.5 8 6.0]);
	plot2d([x x],[(y-L/20) (y+L/20)],5,rect=[-2 -0.5 8 6.0]);
	plot2d([(x+L/2) (x+L/2)],[(y-L/20) (y+L/20)],5,rect=[-2 -0.5 8 6.0]);
	plot2d([(x+L) (x+L)],[(y-L/20) (y+L/20)],5,rect=[-2 -0.5 8 6.0]);
	xstring((N*1.1)/magnfac+x,y,sprintf('%4.0f ', N));
end
// From local x-coordinates to global coordinates of the beam element.
An=size(eci);
Nbr=An(1);
A=zeros(Nbr,2)
A(1,1)=ex(1);
A(1,2)=ey(1);
for i=2:Nbr
	A(i,1)=A(1,1)+eci(i)*n(1);
	A(i,2)=A(1,2)+eci(i)*n(2);
end

B=A;
for i=1:Nbr
	A(i,1)=A(i,1)+es(i)*n(2);
	A(i,2)=A(i,2)-es(i)*n(1);
end
// Type is set to 0 by default.
pl=0;
if nargin==4
	// Do not plot if input arguments are missing.
	pl=3;
end
if pl==0
	// Plots striped diagrams.
	for i=1:Nbr
		plot2d([B(i,1) A(i,1)],[B(i,2) A(i,2)],5,rect=[-2 -0.5 8 6.0]);
	end
end
if pl<3
	plot2d(A(:,1),A(:,2),5,rect=[-2 -0.5 8 6.0]);
	plot2d([ex(1) A(1,1)],[ey(1) A(1,2)],5,rect=[-2 -0.5 8 6.0]);
	plot2d([ex(2) A(Nbr,1)],[ey(2) A(Nbr,2)],5,rect=[-2 -0.5 8 6.0]);
	
	plot2d(ex',ey',rect=[-2 -0.5 8 6.0]);
	
end
endfunction












